/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.BinaryPersistenceReader;
import frc.emul.util.BinaryPersistenceWriter;

public final class BinaryPersistenceHeader {
    private static final String HEADER_ID = "ParaJVE/save";
    private static final int FORMAT_070 = 70;
    private static final int FLAG_COMPRESSED = 128;
    private static final int FLAG_DEBUG = 64;
    private static final int FLAG_ATTACHMENT = 32;
    private static final int FLAG_MASK_TYPE = 7;
    public static final int SAVE_TYPE_UNKNOWN = 0;
    public static final int SAVE_TYPE_AUTO = 1;
    public static final int SAVE_TYPE_USER = 2;
    public static final int SAVE_TYPE_QUICK = 3;
    public static final int SAVE_TYPE_DUMP = 4;
    public static final String PATH_SEEKING = "File-Seek";
    public static final String PATH_FILEIO = "File-System";
    public static final String PATH_HEADER = "File-Header";
    public static final String PATH_CHECKS = "File-Check";
    public static final String PATH_SECTION = "Data-Section";
    public static final int V_070_BETA4 = 100308;
    private boolean flag_compress;
    private boolean flag_debug;
    private boolean flag_attachment;
    private long saveDate;
    private int saveType;
    private int saveFormat;
    private int saveVersion;
    private int gameCRC32;
    private String gameID;

    public BinaryPersistenceHeader() {
        this(false, 0);
    }

    public BinaryPersistenceHeader(boolean bl) {
        this(bl, 0);
    }

    public BinaryPersistenceHeader(boolean bl, int n) {
        this.setCompressed(bl);
        this.setSaveType(n);
    }

    public void setCompressed(boolean bl) {
        this.flag_compress = bl;
    }

    public void setDebugEnabled(boolean bl) {
        this.flag_debug = bl;
    }

    public void setHasAttachment(boolean bl) {
        this.flag_attachment = bl;
    }

    public void setSaveType(int n) {
        this.saveType = n;
    }

    public boolean isCompressed() {
        return this.flag_compress;
    }

    public boolean isDebugEnabled() {
        return this.flag_debug;
    }

    public boolean hasAttachment() {
        return this.flag_attachment;
    }

    public int getSaveType() {
        switch (this.saveType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.saveType;
            }
        }
        return 0;
    }

    long getSaveDate() {
        return this.saveDate;
    }

    int getSaveVersion() {
        return this.saveVersion;
    }

    int getSaveFormat() {
        return this.saveFormat;
    }

    void storeHeader(CfgItemGame cfgItemGame, BinaryPersistenceWriter binaryPersistenceWriter) throws PersistenceException {
        try {
            this.saveFormat = 70;
            this.saveVersion = 101229;
            this.gameID = cfgItemGame.getID();
            this.gameCRC32 = (int)cfgItemGame.info.getBinaryCRC32();
            this.saveDate = System.currentTimeMillis();
            int n = (this.isCompressed() ? 128 : 0) | (this.isDebugEnabled() ? 64 : 0) | (this.hasAttachment() ? 32 : 0) | this.getSaveType() & 7;
            binaryPersistenceWriter.writeID(HEADER_ID);
            binaryPersistenceWriter.write16(this.saveFormat);
            binaryPersistenceWriter.write(this.saveVersion);
            binaryPersistenceWriter.write(this.gameID);
            binaryPersistenceWriter.write(this.gameCRC32);
            binaryPersistenceWriter.write(this.saveDate);
            binaryPersistenceWriter.write8(n);
        }
        catch (Exception exception) {
            throw new PersistenceException(PATH_HEADER, "Failed to write the file header", exception);
        }
    }

    void loadHeader(CfgItemGame cfgItemGame, BinaryPersistenceReader binaryPersistenceReader) throws PersistenceException {
        boolean bl = cfgItemGame != null;
        try {
            int n;
            String string;
            if (!binaryPersistenceReader.checkID(HEADER_ID)) {
                throw new PersistenceException(PATH_HEADER, "Not a ParaJVE save file");
            }
            this.saveFormat = binaryPersistenceReader.readU16();
            if (this.saveFormat != 70) {
                throw new PersistenceException(PATH_HEADER, "This save file is not compatible with the current version of ParaJVE.");
            }
            this.saveVersion = binaryPersistenceReader.readInt();
            this.gameID = binaryPersistenceReader.readStr();
            if (bl && !(string = cfgItemGame.getID()).equalsIgnoreCase(this.gameID)) {
                throw new PersistenceException(PATH_HEADER, "The name of this save game's cartridge does not match the current one.");
            }
            this.gameCRC32 = binaryPersistenceReader.readInt();
            if (bl && this.gameCRC32 != (n = (int)cfgItemGame.info.getBinaryCRC32())) {
                throw new PersistenceException(PATH_HEADER, "The content of this save game's cartridge does not match the current one.");
            }
            this.saveDate = binaryPersistenceReader.readLong();
            int n2 = binaryPersistenceReader.readU8();
            this.setCompressed((n2 & 0x80) != 0);
            this.setDebugEnabled((n2 & 0x40) != 0);
            this.setHasAttachment((n2 & 0x20) != 0);
            this.setSaveType(n2 & 7);
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            throw new PersistenceException(PATH_HEADER, "Error while reading the save file header.", exception);
        }
    }

    boolean checkStaticHeader(BinaryPersistenceReader binaryPersistenceReader) {
        try {
            if (binaryPersistenceReader.checkID(HEADER_ID)) {
                return binaryPersistenceReader.readU16() == 70;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    boolean checkHeader(int n, String string, BinaryPersistenceReader binaryPersistenceReader) {
        if (this.checkStaticHeader(binaryPersistenceReader)) {
            block4: {
                try {
                    binaryPersistenceReader.skip(4);
                    if (string.equalsIgnoreCase(binaryPersistenceReader.readStr())) break block4;
                    return false;
                }
                catch (Exception exception) {}
            }
            return binaryPersistenceReader.readInt() == n;
        }
        return false;
    }
}

